/*
 * clGeniviAudioCtrlAdapter.h
 *
 *  Created on: Jul 25, 2013
 *      Author: vo84hi
 */

#ifndef CLGENIVIAUDIOCTRLADAPTER_H_
#define CLGENIVIAUDIOCTRLADAPTER_H_

#include "InterfaceAudioStack.h"

#include "audiomanagertypes.h"
#include "IAmControlReceiverShadow.h"
#include "AudioStack/clGeniviAudioSource.h"
#include "amcontrol_clienthandler_fc_audioroutemanager.h"

#ifndef _DO_NOT_USE_BOSCH_OSAL_
#define SYSTEM_S_IMPORT_INTERFACE_LIST
#define SYSTEM_S_IMPORT_INTERFACE_ALGORITHM
#include <stl_pif.h>
#else
#include <list>
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_SERVICEINFO
#include "midw_fi_if.h"

#define GAM_AUDIO_SINK_ID 1



namespace AudioStack
{


/**
 * GeniviAudioControlAdapter_mainConnectionItem
 */
struct stGACA_mainConnectionItem
{
   am::am_Handle_s* handle;
   am::am_MainConnection_s* mainConnection;
   am::am_connectionID_t connectionID;
};



/**
 * Facade for Genivi Audiomanager  AudioStack
 */
class clGeniviAudioCtrlAdapter
{

private:
   clGeniviAudioCtrlAdapter();
   ~clGeniviAudioCtrlAdapter();


   /**
    * source observer listing
    */
   static std::map<am_sourceID_t, SourceID > m_registeredSources;

   /**
    * pointer to Genivi AudioManager Control Interface
    */
   static am::IAmControlReceive * m_geniviControlIF;
   static amcontrol_clienthandler_fc_audioroutemanager* m_clientHandlerAudioRouteMgr;

   static am::am_domainID_t m_domainID;


   static am::am_Error_e addMainConnection(const am::am_sourceID_t sourceID,
                                                          const am::am_sinkID_t sinkID,
                                                          am::am_mainConnectionID_t& mainConnectionID);

   static am::am_Error_e removeMainConnectionDB(const am_mainConnectionID_t mainConnectionID);
   static am::am_Error_e getConnectionOfSource(AudioSources::enAudioSources sourceID, am_connectionID_t& connectionID);
   static tVoid initializeSourceClasses(am::am_domainID_t domainID);
   static tVoid initializeSources(am::am_domainID_t domainID);
   static tVoid initializeSinks(am::am_domainID_t domainID);

public:

   typedef enum
   {
      CMD_SRC_OFF
      , CMD_SRC_ON
      , CMD_SRC_LIST
      , CMD_RESET
      , CMD_PRINT
      , CMD_SET_RUNLEVEL
      , CMD_GET_RUNLEVEL
      , CMD_KILL_SRC
      , CMD_SET_SRC_AVAILABLE
      , CMD_SET_SRC_NOT_AVAILABLE
      , CMD_SET_SRC_AVAILABLE_UNKOWN
      , CMD_READXML

   } enCommand;

   static void ReadXML();

   static void Init(am::IAmControlReceive* pGeniviCtrlIF,
         amcontrol_clienthandler_fc_audioroutemanager* clientHandlerAudioRouteMgr);

   static void inline Check_IAmControlReceive();

   template<class TClass>
   static void vSwitchThreadContext(TClass* instance, void (TClass::*function)())
   {
      IAmControlReceiverShadow* pReceiveShadow = IAmControlReceiverShadow::getInstance();
      if(pReceiveShadow != NULL)
      {
         pReceiveShadow->vSwitchThreadContext<TClass>(instance, function);
      }
      //m_geniviControlIF->vSwitchThreadContext<TClass>(instance, function);
   }

   static am_domainID_t GetDomainID() {return m_domainID;}

   static clAudioSource::enSourceActivity           Ext2Int_Activity          (midw_fi_tcl_e8_SrcActivity::tenType extActivity);
   static AudioSources::enAudioSources              Ext2Int_SrcClass          (midw_fi_tcl_e8_AudSource::tenType enSrcExt);
   static clAudioSource::enSourceAvailability       Ext2Int_Availability      (midw_fi_tcl_e8_SrcAvailability::tenType extAvailability);
   static clAudioSource::enSourceAvailabilityReason Ext2Int_AvailabilityReason(midw_fi_tcl_e8_SrcAvailabilityReason::tenType extAvailabilityReason);

   static void Reset();
   /**
    * Adds a Source to a observer list. Incoming events that are
    * destined for source will be forwarded to all objects in the
    * observer list
    *
    * @param pSource source that is added to observer list
    */
   static am_sourceID_t AddSource(SourceID srcID, am_Source_s& gam_source_s);

   /**
    * Removes a Source from the observer list.
    * @param pSource
    * @return TRUE if source is removed or not listed. FALSE if source could
    * not be removed.
    */
   static tVoid RemoveSource(am_sourceID_t gam_sourceID);

   /**
    * Notification that a Source has send notification about
    * its availability state
    * @param Source whom the given availability state belongs to
    * @param SubSource SubSourceID
    * @param Availability state of the source
    * @param Reason why this availability was announced
    */
   static tVoid SourceAvailabilityChange(midw_fi_tcl_e8_AudSource::tenType Source,
                                         tU16 SubSource,
                                         midw_fi_tcl_e8_SrcAvailability::tenType Availability,
                                         midw_fi_tcl_e8_SrcAvailabilityReason::tenType Reason);


   /**
    * Adds Genivi AudioManager Control Interface for interaction with
    * Genivi AudioManager. When Interface becomes invalid (e.g. due
    * to destruction) the Interface needs to be removed.
    * @note when assigning NULL the interface won't get called.
    *
    * @param pGeniviCtrlIF pointer to Genivi AudioManager Control Interface
    * @return void
    */
   static tVoid AddGeniviCtrlIF(am::IAmControlReceive* pGeniviCtrlIF);

   /**
    * Removes the Genivi AudioManager Control Interface.
    * @return void
    */
   static tVoid RemoveGeniviCtrlIF();

   /**
    * Add Interface to INC Gateway to AudioRouteManager
    */
   static tVoid AddAudioRouteMgrIF(amcontrol_clienthandler_fc_audioroutemanager* clientHandlerAudioRouteMgr);

   /**
    * Remove Interface to INC Gateway to AudioRouteManager
    */
   static tVoid RemoveAudioRouteMgrIF();

   static tVoid AddDomainID(am_domainID_t domainID);


   /**
    *
    * @return Poionter to Genivi AudioManager Ctrl Interface
    */
   static am::IAmControlReceive* GetGeniviCtrlIF();

   /**
    * Request by Genivi AudioManager to disconnect MainConnection (SourceOFF)
    * @param connectionID
    * @return
    */
   static am::am_Error_e hookUserDisconnectionRequest(const am::am_mainConnectionID_t connectionID);

   /**
    * Request by Genivi AudioManager to establish MainConnection (SourceOn)
    * @param sourceID
    * @param sinkID
    * @param mainConnectionID
    * @return
    */
   static am::am_Error_e hookUserConnectionRequest(const am::am_sourceID_t sourceID, const am::am_sinkID_t sinkID, am::am_mainConnectionID_t& mainConnectionID);

   /**
    * Request from source to Genivi AudioManager Receive IF
    * @param handle
    * @param connectionID
    * @return
    */
   static am::am_Error_e disconnect(am::am_Handle_s& handle, am::am_connectionID_t connectionID);

   /**
    * from source/AudioStack to AudioManager
    * @param handle
    * @param errorID
    */
   static void cbAckDisconnect(const am::am_Handle_s handle, const am::am_Error_e errorID);

   /**
    * Request from source to Genivi AudioManager Receive IF
    * @param handle
    * @param connectionID
    * @param format
    * @param sourceID
    * @param sinkID
    * @return
    */
   static am::am_Error_e connect(am::am_Handle_s&, am::am_connectionID_t&, am::am_ConnectionFormat_e, am::am_sourceID_t, am::am_sinkID_t);

   /**
    * From Genivi AudioManager to source
    * @param handle
    * @param errorID
    */
   static void cbAckConnect(const am::am_Handle_s handle, const am::am_Error_e errorID);

   /**
       * From Genivi AudioManager to source
       * @param handle
       * @param errorID
       */
   static void cbAckSourceState(const am_Handle_s handle, const am_Error_e error);

   /**
    * From AudioRoutingMgr via INC Adapter to AudioStack
    * @param sourceClassID MidwFI Value
    * @param sourceState source state of the source
    */
   static void handleSourceStatus(midw_fi_tcl_e8_SrcActivity::tenType activity, midw_fi_tcl_e8_AudSource::tenType source, tU16 subSrc = 0);

   /**
    * From AudioRoutingMgr via INC Adapter to AudioStack
    * @param enAudioSources
    */
   static void vHandleSourceError(midw_fi_tcl_e8_AudSource::tenType);

   /**
    * From AudioStack to GeniviAudioManager
    */
   static am::am_Error_e setSourceState(am::am_Handle_s& handle,
         const am::am_sourceID_t sourceID,
         am::am_SourceState_e state);

   /**
    * add a source class
    */
   static am::am_Error_e addSourceClass( am_SourceClass_s& srcClass, am_sourceClass_t& srcClassID);

   /**
    * get the main connection id
    */
   static am::am_Error_e getMainConnectionOfSource(am_sourceID_t sourceID, am::am_mainConnectionID_t& mainConnectionID);

   /**
    * from source/AudioStack to AudioManager
    * @param mainconnectionID
    * @param connectionState
    * @return
    */
   static am::am_Error_e changeMainConnectionStateDB(const am::am_sourceID_t sourceID,
                                                  const am::am_sinkID_t sinkID,
                                                  const am::am_ConnectionState_e connectionState);

   /**
    * Request Source deactivation at AudioStack
    */
   static am::am_Error_e RequestSourceOff(midw_fi_tcl_e8_AudSource::tenType source, tU16 subID);
   static am::am_Error_e RequestSourceOff(const am_sourceID_t source);
   static am::am_Error_e RequestSourceOff(const SourceID srcID);

   /**
    * Request Source pausing at AudioStack
    * ATTENTION: Actually not supported
    */
   static am::am_Error_e RequestSourcePause(SourceID srcID);

   /**
    * Request Source activation at AudioStack
    */
   static am::am_Error_e RequestSourceOn(midw_fi_tcl_e8_AudSource::tenType source, tU16 subID);
   static am::am_Error_e RequestSourceOn(const am_sourceID_t source);
   static am::am_Error_e RequestSourceOn(const SourceID srcID);

   /**
    * Send SourceActivity requests to FC_AudioRouteMgr via INC Gateway
    */
   static am::am_Error_e SourceActivityRequest(midw_fi_tcl_e8_AudSource::tenType source,
                                                midw_fi_tcl_e8_AudSource::tenType possibleNextSource,
                                                midw_fi_tcl_e8_SrcActivity::tenType activity);

   /**
    * From AudioStack to Genivi
    * When restoring last source a main connections is established
    */
   static am::am_Error_e addMainConnection(am_sourceID_t sourceID);
   /**
    * From AudioStack to Genivi
    * when a source has changed to Pause or Off state
    */
   static am::am_Error_e removeMainConnection(am_sourceID_t sourceID);

   /**
    * From AudioStack to Genivi
    * attach or remove connections to MainConnections
    */
   static am::am_Error_e changeMainConnectionRouteDB(am_sourceID_t sourceID,  std::vector<am_connectionID_t>& listConnectionID);

   /**
    * To Map External(midw_fi) source ID to
    * Internal source ID used in Genivi Audio Manager
    */
   //static AudioSources::enAudioSources enMapExtSrcID_To_IntSrcID(midw_fi_tcl_e8_AudSource::tenType enSrcExt,bool bError);

   /**
    * To check if system is already Muted
    */
   //static tBool bIsAudioMuted();

   /**
    * To check if source is current active source
    */
   static tBool bIsCurrentActiveAudiosource(SourceID srcID);


   static tVoid TTFisInput(tU8 cmd,tU16 value1 = 0xFFFF,tU16 value2 = 0xFFFF);
   static tVoid vTraceRxDefault(tPCUChar pcu8Data);



};


}//namespace


#endif /* CLGENIVIAUDIOCTRLADAPTER_H_ */
